package org.papervision3d.materials.special {
	
	import flash.display.Graphics;
	
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.core.render.data.RenderSessionData;
	import org.papervision3d.core.render.material.IUpdateBeforeMaterial;
	import org.papervision3d.objects.special.VectorShape3D;
	import org.papervision3d.objects.special.commands.CurveTo;
	import org.papervision3d.objects.special.commands.LineTo;
	import org.papervision3d.objects.special.commands.MoveTo;	

	public class PhongFlatLetter3DMaterial extends Letter3DMaterial implements IUpdateBeforeMaterial {
		
		public var scaleStroke:Boolean = true;
		private var _colors:Array;
		
		public function PhongFlatLetter3DMaterial(light:LightObject3D, specular:uint = 0xffffff, power:int = 50, diffuse:uint=0x808080, ambient:uint=0x000000) {
			this.fillColor = fillColor;
			this.fillAlpha = fillAlpha;
		}
		
		public override function drawShape(vectorShape:VectorShape3D, graphics:Graphics, renderSessionData:RenderSessionData):void {
			
		}

		override public function drawShape(vectorShape : VectorShape3D, graphics : Graphics, renderSessionData : RenderSessionData):void {
			
			if (fillAlpha > 0) graphics.beginFill(fillColor, fillAlpha);
			
			if (lineAlpha == 0 || lineThickness == 0 || scaleStroke == true)
				graphics.lineStyle();
			else
				graphics.lineStyle(lineThickness, lineColor, lineAlpha);
	
			super.drawShape(vectorShape, graphics, renderSessionData);
			
			if(lineAlpha == 0 || lineThickness == 0 || scaleStroke == false)return;
			var prevVertex : Vertex3D;
			for (var i:int = 0; i < vectorShape.graphicsCommands.length; i++) {
				if(vectorShape.graphicsCommands[i] is MoveTo)
					prevVertex = MoveTo(vectorShape.graphicsCommands[i]).vertex;
					
				if (vectorShape.graphicsCommands[i] is LineTo) {
					LineTo(vectorShape.graphicsCommands[i]).drawScaledStroke( prevVertex , graphics, renderSessionData , this);
					prevVertex = LineTo(vectorShape.graphicsCommands[i]).vertex;
				}
				
				if (vectorShape.graphicsCommands[i] is CurveTo) {
					CurveTo(vectorShape.graphicsCommands[i]).drawScaledStroke( prevVertex , graphics, renderSessionData , this);
					prevVertex = CurveTo(vectorShape.graphicsCommands[i]).anchor;
				}
			}
		}
	}
}